--Loadouts database
-------------------------------------------------------------------------------------------------------

--[[ Loadout Entry Example ----------------------------------------------------------------------------

["MiG-21Bis"] = {														--String, aircraft type
	["Strike"] = {														--String, task
		["Custom Loadout Name"] = {										--String, custom loadout name
			support = {													--Table, list of tasks that can support this loadout (nil = is never added, true = is added when available)
				["Escort"] = true,										--Fighter escort
				["SEAD"] = true,										--SEAD	escort
				["Escort Jammer"] = true,								--Jammer escort
				["Flare Illumination"] = true,							--Target area flare illumination (mandatory support for loadout to be eligible)
				["Laser Illumination"] = true,							--Target laser illumination (mandatory support for loadout to be eligible)
			},
			attributes = {												--Array, custom loadout attributes. Only used by A-G tasks. Any target attribute must be matched in this array for the loadout to be eligible for the target.
				[1] = "Anti-tank",										--String, custom attribute to be matched for target attribute
				[2] = "Stand-off Missile",								--String, custom attribute to be matched for target attribute
			},
			weaponType = "Bombs",										--String, type of ordinance of loadout. Only used by A-G taks. Options: "Cannon", "Rockets", "Bombs", "Guided bombs", "ASM". A-G weapon types cannot be mixed.
			expend = "All",												--String, quantity of wapons expended per attack. Only used by A-G tasks. Options: "Auto", "All", "Half", "Two".
			day = true,													--Boolean, loadout is day capable
			night = true,												--Boolean, loadout is night capable
			adverseWeather = true,										--Boolean, loadout is adverse weather capable
			range = 900000,												--Number, range radius in meters
			capability = 10,											--Number, how good is the aircraft with this loadout. The higher the better
			firepower = 10,												--Number, how much firepower has this loadout. The higher the better
			vCruise = 225,												--Number, cruise speed in m/s
			vAttack = 280,												--Number, attack speed in m/s
			hCruise = 6000,												--Number, cruise altitude in m
			hAttack = 100,												--Number, attack altitude in m
			standoff = 5000,											--Number, attack distance from target in m. Determines attack waypoint distance for A-G with missiles (for Bombss use nil) and engage distance for A-A tasks
			tStation = 1200,											--Number, seconds the aircraft can remain on station. Only used by CAP, AWACS and Refuelling tasks
			LDSD = true,												--Boolean, aircraft is Look-Down/Shoot-Down capable. Only used by CAP and Intercept tasks
			self_escort = false,										--Boolean, aircraft can defend itself against fighters. Only used by A-G tasks
			sortie_rate = 2,											--Number, average amount of sorties that aircraft flies per day
			stores = {													--Table, loadout table for DCS
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{R-60M 2L}",
					},
					[2] = 
					{
						["CLSID"] = "{R-3R}",
					},
					[3] = 
					{
						["CLSID"] = "{PTB_800_MIG21}",
					},
					[4] = 
					{
						["CLSID"] = "{R-3R}",
					},
					[5] = 
					{
						["CLSID"] = "{R-60M 2R}",
					},
					[6] = 
					{
						["CLSID"] = "{ASO-2}",
					},
				},
				["fuel"] = 2280,
				["flare"] = 32,
				["ammo_type"] = 1,
				["chaff"] = 32,
				["gun"] = 100,
			},
		},
	},
},

]]-----------------------------------------------------------------------------------------------------


db_loadouts = {
	["P-47D-30"] = {
		["Intercept"] = {
			["Intercept Fuel"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 20000,
				capability = 5,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
			},
				["fuel"] = 1830,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Escort Fuel"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 160000,
				capability = 5,
				firepower = 1,
				vCruise = 107.28,
				-- vAttack = 213.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 9200,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
			},
				["fuel"] = 1830,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["3xM64"] = {
				minscore = 0.5,
				support = {
					["Escort"] = true,
				},
				attributes = {"Bridge", "Structure", "Parked Aircraft", "soft"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 160000,
				capability = 10,
				firepower = 5,
				vCruise = 107.28,
				vAttack = 134.1,
				hCruise = 2438,
				hAttack = 305,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{AN-M64}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{AN-M64}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{AN-M64}",
					["num"] = 2,
				},
				}, -- end of ["pylons"]
				["fuel"] = 1230,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},		
		},
		["SEAD"] = {
			["3xM64"] = {
				minscore = 0.5,
				support = {
					["Escort"] = true,
				},
				attributes = {"Bridge", "Structure", "Parked Aircraft", "soft", "EWR"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 10,
				firepower = 5,
				vCruise = 107.28,
				vAttack = 134.1,
				hCruise = 2438,
				hAttack = 305,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{AN-M64}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{AN-M64}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{AN-M64}",
					["num"] = 2,
				},
				}, -- end of ["pylons"]
				["fuel"] = 1230,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},		
		},		
	},
	["P-51D-30-NA"] = {
		["Intercept"] = {
			["Intercept Fuel"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 20000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[7] = {
					["CLSID"] = "{DT75GAL}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{DT75GAL}",
					["num"] = 4,
				},
			},
				["fuel"] = 2042,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["CAP Fuel"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 112000,
				capability = 10,
				firepower = 1,
				vCruise = 107.28,
				vAttack = 143.04,
				hCruise = 3657.6,
				hAttack = 3657.6,
				standoff = 18500,
				tStation = 1800,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[7] = {
					["CLSID"] = "{DT75GAL}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{DT75GAL}",
					["num"] = 4,
				},
			},
				["fuel"] = 2042,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Escort Fuel"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 176000,
				capability = 10,
				firepower = 1,
				vCruise = 107.28,
				-- vAttack = 213.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 9200,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[7] = {
					["CLSID"] = "{DT75GAL}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{DT75GAL}",
					["num"] = 4,
				},
			},
				["fuel"] = 2042,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},	
		["Fighter Sweep"] = {
			["Fighter Sweep Fuel"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 5,
				firepower = 1,
				vCruise = 107.28,
				vAttack = 143.04,
				hCruise = 4500,
				hAttack = 4500,
				standoff = 18500,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[7] = {
					["CLSID"] = "{DT75GAL}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{DT75GAL}",
					["num"] = 4,
				},
			},
				["fuel"] = 2042,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},	
		["Strike"] = {
			["Strike 2xM64"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Structure", "Parked Aircraft", "Bridge", "Base"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 171000,
				capability = 10,
				firepower = 5,
				vCruise = 107.28,
				vAttack = 143.04,
				hCruise = 2438.4,
				hAttack = 300,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[7] = {
					["CLSID"] = "{AN-M64}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{AN-M64}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
					["fuel"] = 1129,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			["Strike 10xHVAR"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 171000,
				capability = 10,
				firepower = 5,
				vCruise = 107.28,
				vAttack = 143.04,
				hCruise = 1524,
				hAttack = 61,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[10] = {
					["CLSID"] = "{HVAR}",
					["num"] = 10,
				},
				[9] = {
					["CLSID"] = "{HVAR}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{HVAR}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{HVAR}",
					["num"] = 7,
				},
				[6] = {
					["CLSID"] = "{HVAR}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{HVAR}",
					["num"] = 5,
				},
				[4] = {
					["CLSID"] = "{HVAR}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{HVAR}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{HVAR}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{HVAR}",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
					["fuel"] = 1129,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
		["SEAD"] = {
			["2xM64"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Structure", "EWR"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 171000,
				capability = 10,
				firepower = 5,
				vCruise = 107.28,
				vAttack = 143.04,
				hCruise = 2438.4,
				hAttack = 300,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[7] = {
					["CLSID"] = "{AN-M64}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{AN-M64}",
					["num"] = 4,
				},
				}, -- end of ["pylons"]
					["fuel"] = 1129,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
	},		
	["SpitfireLFMkIX"] = {
		["Intercept"] = {
			["Intercept Fuel"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 20000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "SPITFIRE_45GAL_SLIPPER_TANK",
					["num"] = 2,
				},
			},
				["fuel"] = 815,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["CAP Fuel"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 112000,
				capability = 10,
				firepower = 1,
				vCruise = 107.28,
				vAttack = 134.1,
				hCruise = 2000,
				hAttack = 2000,
				standoff = 18500,
				tStation = 1800,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "SPITFIRE_45GAL_SLIPPER_TANK",
					["num"] = 2,
				},
			},
				["fuel"] = 815,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Escort Fuel"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 100000,
				capability = 5,
				firepower = 1,
				vCruise = 107.28,
				-- vAttack = 213.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 9200,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "SPITFIRE_45GAL_SLIPPER_TANK",
					["num"] = 2,
				},
			},
				["fuel"] = 815,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},	
		["Fighter Sweep"] = {
			["Fighter Sweep Fuel"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 5,
				firepower = 1,
				vCruise = 107.28,
				vAttack = 134.10,
				hCruise = 2000,
				hAttack = 2000,
				standoff = 18500,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 2,
				stores = {
			["pylons"] = {
				[2] = {
					["CLSID"] = "SPITFIRE_45GAL_SLIPPER_TANK",
					["num"] = 2,
				},
			},
				["fuel"] = 815,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},	
		["Strike"] = {
			["Strike 2x250lbs, 1x500lbs"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Structure", "Parked Aircraft", "Bridge", "Base"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 145000,
				capability = 10,
				firepower = 5,
				vCruise = 98.34,
				vAttack = 134.1,
				hCruise = 2438,
				hAttack = 152.4,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[3] = {
					["CLSID"] = "British_GP_250LBS_Bomb_MK4_on_RH_Spitfire_Wing_Carrier",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "British_GP_250LBS_Bomb_MK4_on_LH_Spitfire_Wing_Carrier",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "British_GP_500LBS_Bomb_MK4_on_British_UniversalBC_MK3",
					["num"] = 2,
				},
				}, -- end of ["pylons"]
					["fuel"] = 545,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},	
		["SEAD"] = {
			["2x250lbs, 1x500lbs"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Structure", "EWR"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 145000,
				capability = 10,
				firepower = 5,
				vCruise = 98.34,
				vAttack = 134.1,
				hCruise = 2438,
				hAttack = 152.4,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[3] = {
					["CLSID"] = "British_GP_250LBS_Bomb_MK4_on_RH_Spitfire_Wing_Carrier",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "British_GP_250LBS_Bomb_MK4_on_LH_Spitfire_Wing_Carrier",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "British_GP_500LBS_Bomb_MK4_on_British_UniversalBC_MK3",
					["num"] = 2,
				},
				}, -- end of ["pylons"]
					["fuel"] = 545,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
	},	
	["B-17G"] = {
		["Strike"] = {
			["Strike 12xM64"] = {
				minscore = 1,
				support = {
					["Escort"] = true,
				},
				attributes = {"Base", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 223000,
				capability = 10,
				firepower = 5,
				vCruise = 80.46,
				vAttack = 93.87,
				hCruise = 6400.8,
				hAttack = 6400.8,
				standoff = nil,
				ingress = 8000,
				egress = 1500,
				MaxAttackOffset = 30,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 1,
				stores = {
				["pylons"] = {
					[1] = {
					["CLSID"] = "{12xM64}",
					["num"] = 1,
					},
				}, -- end of ["pylons"]
				["fuel"] = 16755,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
	},	
	["A-20G"] = {
		["Strike"] = {
			["Strike 4xM64"] = {
				minscore = 1,
				support = {
					["Escort"] = true,
				},
				attributes = {"Structure", "Base", "Soft", "Bridge"},
				weaponType = "Bombs",
				expend = "All",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 176000,
				capability = 10,
				firepower = 5,
				vCruise = 80.46,
				vAttack = 93.87,
				hCruise = 3657.6,
				hAttack = 3657.6,
				standoff = nil,
				ingress = 5000,
				egress = 1000,
				MaxAttackOffset = 30,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 1,
				stores = {
				["pylons"] = 
					{
					[1] = {
					["CLSID"] = "{4xAN-M64_on_InvCountedAttachmentPoints}",
					["num"] = 1,
					},
				},
					["fuel"] = 3307,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
	},
	["Bf-109K-4"] = {
		["Intercept"] = {
			["Intercept Fuel"] = {
				attributes = {},
				--weaponType = nil,
				--expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 20000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
					[1] = {
					["CLSID"] = "BF109K_4_FUEL_TANK",
					["num"] = 1,
					},
				}, -- end of ["pylons"]
				["fuel"] = 1280,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Escort Fuel"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 10,
				firepower = 1,
				vCruise = 116.67,
				-- vAttack = 315.83333333333,
				-- hCruise = 7011,
				-- hAttack = 7011,
				standoff = 9200,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "BF109K_4_FUEL_TANK",
					["num"] = 1,
					},
				}, -- end of ["pylons"]
				["fuel"] = 1280,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["CAP Fuel"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 98000,
				capability = 5,
				firepower = 1,
				vCruise = 116.67,
				vAttack = 138.89,
				hCruise = 3657.6,
				hAttack = 3657.6,
				standoff = 18500,
				tStation = 1800,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "BF109K_4_FUEL_TANK",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
				["fuel"] = 1280,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["Fighter Fuel"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 8,
				firepower = 1,
				vCruise = 116.67,
				vAttack = 138.89,
				hCruise = 3048,
				hAttack = 3048,
				standoff = 18500,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "BF109K_4_FUEL_TANK",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
				["fuel"] = 1280,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},	
		},
		["Strike"] = {
			["Strike SC500J"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Structure", "Parked Aircraft", "Bridge", "Base"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 182000,
				capability = 8,
				firepower = 5,
				vCruise = 111.11,
				vAttack = 134.1,
				hCruise = 2438.4,
				hAttack = 152.4,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "SC_501_SC500",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
					["fuel"] = 577,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
		["SEAD"] = {
			["SC500J"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Structure", "EWR", "ship"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 112000,
				capability = 10,
				firepower = 5,
				vCruise = 111.11,
				vAttack = 134.1,
				hCruise = 2438.4,
				hAttack = 152.4,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "SC_501_SC500",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
					["fuel"] = 577,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
	},		
	["FW-190A8"] = {
		["Intercept"] = {
			["Intercept Fuel"] = {
				attributes = {},
				--weaponType = nil,
				--expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 20000,
				capability = 5,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "BF109K_4_FUEL_TANK",
					["num"] = 1,
					},
				}, -- end of ["pylons"]
				["fuel"] = 1378,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Escort Fuel"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 5,
				firepower = 1,
				vCruise = 111.11,
				-- vAttack = 315.83333333333,
				-- hCruise = 7011,
				-- hAttack = 7011,
				standoff = 9200,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "BF109K_4_FUEL_TANK",
					["num"] = 1,
					},
				}, -- end of ["pylons"]
				["fuel"] = 1378,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["CAP Fuel"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 98000,
				capability = 5,
				firepower = 1,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 3657.6,
				hAttack = 3657.6,
				standoff = 18500,
				tStation = 3600,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "BF109K_4_FUEL_TANK",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
				["fuel"] = 1378,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["Fighter Fuel"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 150000,
				capability = 8,
				firepower = 1,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 3048,
				hAttack = 3048,
				standoff = 18500,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = 
				{
				[1] = {
					["CLSID"] = "BF109K_4_FUEL_TANK",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
				["fuel"] = 902,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},	
		},
		["Strike"] = {
			["Strike SC500J"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Structure", "Parked Aircraft", "Bridge", "Base"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 120000,
				capability = 10,
				firepower = 5,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 2438.4,
				hAttack = 152.4,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "SC_501_SC500",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
					["fuel"] = 902,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			["Strike WGr21"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 120000,
				capability = 8,
				firepower = 5,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 2438.4,
				hAttack = 60.96,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[3] = {
					["CLSID"] = "{WGr21}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{WGr21}",
					["num"] = 2,
				},
				}, -- end of ["pylons"]
					["fuel"] = 902,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
		["SEAD"] = {
			["SC500J"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Structure", "Parked Aircraft", "Bridge", "Base"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 120000,
				capability = 10,
				firepower = 5,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 2438.4,
				hAttack = 152.4,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "SC_501_SC500",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
					["fuel"] = 902,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
		["Anti-ship Strike"] = {
			["Antiship SC500J"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"ship"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 120000,
				capability = 10,
				firepower = 5,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 2438.4,
				hAttack = 152.4,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "SC_501_SC500",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
					["fuel"] = 902,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
	},
	["FW-190D9"] = {
		["Intercept"] = {
			["Intercept Fuel"] = {
				attributes = {},
				--weaponType = nil,
				--expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 20000,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "FW109_FUEL_TANK",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
				["fuel"] = 1332,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Escort Fuel"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 10,
				firepower = 1,
				vCruise = 111.11,
				-- vAttack = 315.83333333333,
				-- hCruise = 7011,
				-- hAttack = 7011,
				standoff = 9200,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "FW109_FUEL_TANK",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
				["fuel"] = 1332,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["CAP Fuel"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 98000,
				capability = 10,
				firepower = 1,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 3657.6,
				hAttack = 3657.6,
				standoff = 18500,
				tStation = 1800,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "FW109_FUEL_TANK",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
				["fuel"] = 1332,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
		["Fighter Sweep"] = {
			["Fighter Fuel"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 300000,
				capability = 10,
				firepower = 1,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 3048,
				hAttack = 3048,
				standoff = 18500,
				tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "FW109_FUEL_TANK",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
				["fuel"] = 1332,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},	
		},
		["Strike"] = {
			["Strike SC500J"] = {
				minscore = 1,
				support = {
					["Escort"] = true,
				},
				attributes = {"soft", "Structure", "Parked Aircraft", "Bridge", "Base"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 149000,
				capability = 8,
				firepower = 5,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 2438.4,
				hAttack = 152.4,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "SC_501_SC500",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
					["fuel"] = 855,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
			["Strike R4M"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 149000,
				capability = 8,
				firepower = 5,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 2438.4,
				hAttack = 60.96,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[3] = {
					["CLSID"] = "{FW_190_R4M_RGHT_WING}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{FW_190_R4M_LEFT_WING}",
					["num"] = 2,
				},
				}, -- end of ["pylons"]
					["fuel"] = 855,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
		["SEAD"] = {
			["SC500J"] = {
				minscore = 1,
				support = {
					["Escort"] = false,
				},
				attributes = {"soft", "Structure", "EWR", "ship"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = false,
				range = 300000,
				capability = 5,
				firepower = 5,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 4572,
				hAttack = 152.4,
				standoff = nil,
				tStation = nil,
				-- LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "SC_501_SC500",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
					["fuel"] = 855,
					["flare"] = 0,
					["chaff"] = 0,
					["gun"] = 100,
				},
			},
		},
		["Anti-ship Strike"] = {
			["Antiship SC50"] = {
				minscore = 1,
					support = {
						["Escort"] = false,
					},
				attributes = {"ship"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				attackType = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 149000,
				capability = 10,
				firepower = 5,
				vCruise = 111.11,
				vAttack = 125,
				hCruise = 4572,
				hAttack = 609.6,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "ER_4_SC50",
					["num"] = 1,
				},
                }, -- end of ["pylons"]	
				["fuel"] = 855,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
	},	
	["Ju-88A4"] = {	
		["Anti-ship Strike"] = {
			["Antiship  Torpedo"] = {
					minscore = 0.5,
					support = {
						["Escort"] = true,
					},
				attributes = {"ship"},
				weaponType = "ASM",
				expend = "All",
				attackType = nil,
				day = true,
				night = true,
				adverseWeather = false,
				range = 205000,
				capability = 10,
				firepower = 10,
				vCruise = 93.87,
				vAttack = 107.28,
				hCruise = 1828.8,
				hAttack = 30.48,
				standoff = 804,
				ingress = 3218.69,
				egress = 1000,
				MaxAttackOffset = 30,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 1,
				stores = {
				["pylons"] = 
                {
				[3] = {
					["CLSID"] = "{LTF_5B}",
					["num"] = 3,
				},
				[1] = {
					["CLSID"] = "{LTF_5B}",
					["num"] = 1,
				}, 
                }, -- end of ["pylons"]	
				["fuel"] = 4674,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
	},
}
	